% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{eval.config.merge}
\alias{eval.config.merge}
\title{Merge config parameter sets by groups.}
\usage{
eval.config.merge(file = "config.json", groups = NULL,
  encoding = getOption("encoding"))
}
\arguments{
\item{file}{Configuration file to read from (defaults to 'config.json') 
'JSON/INI/YAML format file.}

\item{groups}{Need be merged parameter sets, eg. groups=c('default', 'version'), will 
default to all of config groups}

\item{encoding}{Encoding of filepath parameter, will default to system encoding if not specifield}
}
\value{
a list
}
\description{
Merge config parameter sets by groups.
}
\examples{
config.json <- system.file('extdata', 'config.json', package='configr')
eval.config.merge(config.json)
}
\seealso{
\code{\link{eval.config.groups}} which only get all of the mainly parameter sets name in config file, 
\code{\link{read.config}} which only read from a config as a list,
\code{\link{eval.config}} which only read one groups as config obj or a value from config file.
}

