% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_runtimes}
\alias{get_runtimes}
\title{Get available runtimes on server}
\usage{
get_runtimes(client, runtimes = NULL)
}
\arguments{
\item{client}{A \code{Connect} object.}

\item{runtimes}{Optional. A character vector of runtimes to include. Must be
some combination of \code{"r"}, \code{"python"}, \code{"quarto"}, and \code{"tensorflow"}. Quarto
is only supported on Connect >= 2021.08.0, and Tensorflow is only supported
on Connect >= 2024.03.0.}
}
\value{
A tibble with columns for \code{runtime}, \code{version}, and \code{cluster_name}
and \code{image_name}. Cluster name and image name are only meaningful on Connect
instances running off-host execution.
}
\description{
Get a table showing available versions of R, Python, Quarto, and Tensorflow
on the Connect server.
}
\examples{
\dontrun{
library(connectapi)
client <- connect()
get_runtimes(client, runtimes = c("r", "python", "tensorflow"))
}

}
