% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_aws_content_credentials}
\alias{get_aws_content_credentials}
\title{Obtain AWS credentials for your content.}
\usage{
get_aws_content_credentials(
  connect,
  content_session_token = NULL,
  audience = NULL
)
}
\arguments{
\item{connect}{A Connect R6 object.}

\item{content_session_token}{Optional. The content session token. This token
can only be obtained when the content is running on a Connect server. The
token identifies the service account integration previously configured by
the publisher on the Connect server. Defaults to the value from the
environment variable: \code{CONNECT_CONTENT_SESSION_TOKEN}}

\item{audience}{Optional. The GUID of an OAuth integration associated with
this piece of content.}
}
\value{
The AWS credentials as a list with fields named \code{access_key_id},
\code{secret_access_key}, \code{session_token}, and \code{expiration}.
}
\description{
Obtain AWS credentials for your content.
}
\details{
Please see https://docs.posit.co/connect/user/oauth-integrations/#obtaining-service-account-aws-credentials
for more information. See the example below of using this function with
\code{paws} to access S3. Any library that allows you to pass AWS credentials
will be able to utilize the credentials returned from this function call.
}
\examples{
\dontrun{
library(connectapi)
library(paws)

client <- connect()
# Pulls the content session token from the environment
# when deployed into Connect.
aws_credentials <- get_aws_content_credentials(client)

# Create S3 client with AWS credentials from Connect
svc <- paws::s3(
  credentials = list(
    creds = list(
      access_key_id = aws_credentials$access_key_id,
      secret_access_key = aws_credentials$secret_access_key,
      session_token = aws_credentials$session_token
    )
  )
)

# Get object from S3
obj <- svc$get_object(
  Bucket = "my-bucket",
  Key = "my-data.csv"
)
}

}
