% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infoHelpers.R
\name{informationWrightMap2}
\alias{informationWrightMap2}
\title{informationWrightMap2}
\usage{
informationWrightMap2(
  myItems,
  myAbilities,
  minTheta = -6,
  maxTheta = 6,
  stepTheta = 0.1,
  scaleInfo = 1
)
}
\arguments{
\item{myItems}{A list of sets of item parameters.}

\item{myAbilities}{A vector of person abilities.}

\item{minTheta}{The smallest value of ability PDF to plot.}

\item{maxTheta}{The largest value of ability PDF to plot.}

\item{stepTheta}{The increment to iterate over the ability PDF. Defaults to 0.01.}

\item{scaleInfo}{A scaling factor to apply to the plot of tesr information.
Because ability distribution is a PDF with area one, and a test information function has area L, 
this can make the plot more interpretable. Defaults to 1.}
}
\value{
A ggplot2 object.
}
\description{
Plots test information function, relative to ability density, and item locations (delta dots).
}
\examples{
myDetaDot <- data.frame(
  id = 1:10,
  itemid = paste0("item_", letters[1:10]),
  delta = runif(n = 10, min = -3, max = 2)
)
myTau<- data.frame(
  id = c(rep(1:2, each = 1), rep (3, 2)), 
  itemid = paste0("item_", c(rep(letters[1:2], each = 1), rep(letters[3], 2))),
  step = c(1, 1, 1, 2),
  tau = c(-1.2, -0.3, -0.2, -0.1)
)
myItemParams<- makeItemList(myDetaDot, myTau)
myAbil <- rnorm(1000, 0, 1)
myInfoPlot <- informationWrightMap2(myItems= myItemParams, myAbilities = myAbil)
}
