% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertId2.R
\name{convert.alias}
\alias{convert.alias}
\title{Convert Symbols to Aliases and Vice Versa.}
\usage{
convert.alias(id, species = c("Human", "Mouse"), db = NULL)
}
\arguments{
\item{id}{(\code{character}). Vector of gene symbols.}

\item{species}{(\code{character}). One of "Human" and "Mouse". Defaults to "Human".}

\item{db}{(\code{AnnotationDb object}). Annotation package object.}
}
\value{
A \code{data.frame} with two columns:
\tabular{ll}{
\tab 'SYMBOL': The official gene symbol.\cr
\tab 'ALIAS': All possible aliases.\cr
}
}
\description{
\command{convert.alias()} attempts to find all possible symbol-alias combinations for a given gene symbol, i.e.,
    it assumes the input ID to be either an Alias or a Symbol and performs multiple queries to find all possible
    counterparts. The input IDs are converted to title and upper case before querying and all possibilities are tested.
    There are species presets for Human and Mouse annotations.
}
\examples{
convert.alias("TRPV4")
}
\seealso{
\code{\link[AnnotationDbi]{select}}
}
