% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kde2.R
\name{kde2}
\alias{kde2}
\title{2D adaptive kernel density estimation}
\usage{
kde2(
  x,
  y,
  w = NULL,
  s = 1,
  n = c(20, 20),
  xlim = range(x),
  ylim = range(y),
  sd.min = NULL,
  sd.max = NULL,
  reflect = "",
  smoothw = FALSE
)
}
\arguments{
\item{x}{N-element vector of x-coordinates or N-by-2 matrix of (x,y)-coordinates}

\item{y}{N-element vector of y-coordinates (only used if x is a vector)}

\item{w}{optional N-element vector with weights}

\item{s}{characteristic smoothing length}

\item{n}{scalar or 2-element vector specifying the number of equally space grid cells}

\item{xlim}{2-element vector specifying the x-range}

\item{ylim}{2-element vector specifying the y-range}

\item{sd.min}{optional value, specifying the minimum blurring of any pixel, expressed in standard deviations in units of pixels}

\item{sd.max}{optional value, specifying the maximum blurring of any pixel, expressed in standard deviations in units of pixels}

\item{reflect}{vector of characters c('left','right','bottom','top') specifying the edges, where the data should be reflected}

\item{smoothw}{logical flag; if set TRUE, the smoothing depends on the weighted mass rather than the counts in each pixel.}
}
\value{
Returns a list of items
\item{x}{n-element vector of cell-center x-coordinates.}
\item{y}{n-element vector of cell-center y-coordinates.}
\item{xbreak}{(n+1)-element vector of cell-edge x-coordinates.}
\item{ybreak}{(n+1)-element vector of cell-edge y-coordinates.}
\item{n}{2D array of point counts.}
\item{m}{2D array of weighted point counts (masses); only available if \code{w} is specified.}
\item{d}{2D array of smoothed density field.}
}
\description{
Produces a 2D kernel density estimation on a 2D grid from a 2D point set, using adaptive smoothing and allowing for the data points to have weights.
}
\seealso{
\code{\link{griddata}}
}
\author{
Danail Obreschkow
}
