% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singlevar.R
\name{cophe.single.lbf}
\alias{cophe.single.lbf}
\title{cophe.single.lbf}
\usage{
cophe.single.lbf(dataset, querysnpid, querytrait, MAF = NULL)
}
\arguments{
\item{dataset}{a list with specifically named elements defining the query trait dataset
to be analysed.}

\item{querysnpid}{Id of the query variant, (id in dataset$snp)}

\item{querytrait}{Query trait name}

\item{MAF}{Minor allele frequency vector}
}
\value{
data frame with log bayes factors for Hn and Ha hypotheses
}
\description{
Calculate log bayes factors for each hypothesis (Single causal variant assumption)
}
\examples{
library(cophescan)
data(cophe_multi_trait_data)
query_trait_1 <- cophe_multi_trait_data$summ_stat[['Trait_1']]
querysnpid <- cophe_multi_trait_data$querysnpid
res.single.lbf <- cophe.single.lbf(query_trait_1, querysnpid = querysnpid, querytrait='Trait_1')
res.single.lbf
}
\seealso{
\code{\link{cophe.single}}
}
\author{
Ichcha Manipur
}
