% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbevent.R
\name{nbevent}
\alias{nbevent}
\title{Number of events estimates}
\usage{
nbevent(hypsurv,pe,alfa,beta,design)
}
\arguments{
\item{hypsurv}{For Superiority=c(Sc,Se); for Non inferiority=c(Sc,Se,SeA); for Equivalence=c(Sc, Se),
with Sc is survival rate in the control arm; Se is survival rate in experimental arm; SeA is the survival rate in the experimental arm under the alternative hypothesis.}

\item{pe}{Proportion (ratio) of patients assigned to the experimental arm (with 0<pe<1).}

\item{alfa}{Type I error, for Non inferiority, Equivalence and 1-sided superiority, alfa is a vector of length one. 
For 2-sided superiority, alfa is a vector to length two c(alpha.low, alpha.up).}

\item{beta}{Probability of a type II error.}

\item{design}{Superiority=c(1,sided)[with sided=1 if 1-sided and 2 if 2-sided]; Non inferiority=c(2); Equivalence=c(1,1)}
}
\value{
E: Number of events

h: Hazard Ratio under null hypothesis(HR=log(Se)/log(Sc))

h.alt: Hazard Ratio under alternative hypothesis (h.alt=log(SeA)/log(Sc))
}
\description{
To determine the sample size N in clinical trials with time to event endpoint, it is necessary to proceed in two steps. In the first step, 
the numbers of events that need to be observed (e) are computed. In the second step, we determine the number of patients necessary to observe the number of events required.
This function computes the number of event for one-time-to event.
}
\details{
The nbevent function computes the required number of events to determine the number of patients.
}
\references{
Chow, S. C., Shao, J., Wang, H. (2003). Sample Size Calculation in Clinical Research. New York: Marcel Dekker.

Schoenfeld. Sample-size formula for the proportional-hazards regression model. Biometrics. 1983 39<499>503.
}

