% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootmds.pcops.R
\name{bootmds.pcops}
\alias{bootmds.pcops}
\title{MDS Bootstrap for pcops objects}
\usage{
\method{bootmds}{pcops}(
  object,
  data,
  method.dat = "pearson",
  nrep = 100,
  alpha = 0.05,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{object}{Object of class smacofP if used as method or another object inheriting from smacofB (needs to be called directly as bootmds.smacofP then).}

\item{data}{Initial data (before dissimilarity computation).}

\item{method.dat}{Dissimilarity computation used as MDS input. This must be one of "pearson", "spearman", "kendall", "euclidean", "maximum", "manhattan", "canberra", "binary".}

\item{nrep}{Number of bootstrap replications.}

\item{alpha}{Alpha level for condfidence ellipsoids.}

\item{verbose}{If 'TRUE', bootstrap index is printed out.}

\item{...}{Additional arguments needed for dissimilarity computation as specified in \code{\link[smacof]{sim2diss}}.}
}
\value{
An object of class 'smacofboot', see \code{\link[smacof]{bootmds}}. With values 
\itemize{
\item cov: Covariances for ellipse computation
\item bootconf: Configurations bootstrap samples
\item stressvec: Bootstrap stress values
\item bootci: Stress bootstrap percentile confidence interval
\item spp: Stress per point (based on stress.en) 
\item stab: Stability coefficient
}
}
\description{
Performs a bootstrap on an MDS solution. It works for derived dissimilarities only, i.e. generated by the call dist(data). The original data matrix needs to be provided, as well as the type of dissimilarity measure used to compute the input dissimilarities.
}
\details{
In order to examine the stability solution of an MDS, a bootstrap on the raw data can be performed. This results in confidence ellipses in the configuration plot. The ellipses are returned as list which allows users to produce (and further customize) the plot by hand. See \code{\link[smacof]{bootmds}} for more.
}
\examples{
dats <- na.omit(PVQ40[,1:5])
diss <- dist(t(dats))   ## Euclidean distances 
fit <- pcops(diss,loss="rstress",itmaxi=50) #this is just for illustration: increase itmaxi    
set.seed(123)
resboot <- bootmds(fit, dats, method.dat = "euclidean", nrep = 2)
}
