% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coreHist.R
\name{coreHist}
\alias{coreHist}
\title{Whole-core frequency distribution of Hounsfield units}
\usage{
coreHist(directory = file.choose(), 
units = "percent",
upperLim = 3045, lowerLim = -1025,
means     = c(-850.3233, 63.912, 271.7827, 1345.0696),
sds       = c(77.6953, 14.1728, 39.2814, 45.4129),
densities = c(0.0012, 1, 1.23, 2.2),
returnData = TRUE, pngName = NULL)
}
\arguments{
\item{directory}{a character string that can be (1) a matrix of DICOM images that exists in the global environment, or (2) the address of an individual DICOM file in a folder of DICOM images. The default action is <code>file.choose()</code>; a browser menu appears so the user can select the the desired directory by identifying a single DICOM file in the folder of images.}

\item{units}{units to be used for plotting purposes: either "percent" (the default) or "absolute"}

\item{upperLim}{upper bound cutoff for pixels (Hounsfield Units); upper bound is inclusive}

\item{lowerLim}{lower bound cutoff for pixels (Hounsfield Units); lower bound is exclusive}

\item{means}{mean values (units = Hounsfield Units) for calibration rods used.}

\item{sds}{standard deviations (units = Hounsfield Units) for calibration rods used. Must be in the same order as \code{means}.}

\item{densities}{numeric vector of known cal rod densities. Must be in the same order as \code{means} and \code{sds}.}

\item{returnData}{if \code{TRUE}, voxel counts for each Hounsfield unit from \code{lowerLim} to \code{upperLim} are returned, as are material class definitions. These are the data needed to re-create and modify the frequency plot.}

\item{pngName}{if this is not \code{NULL}, the frequency plot is saved to disk. In that case, \code{pngName} should be a character string containing the name and address of the file.}
}
\value{
list if \code{returnData = TRUE}, a list is returned containing the frequencies for each Hounsfield unit value from \code{lowerLim} to \code{upperLim}, and (2) the boundaries for material classes. Lower boundaries for a component class are exclusive, while upper bounds are inclusive. These materials allow the frequency distribution to be plotted by the user. If \code{returnData = FALSE} the data are plotted in the graphics window, but nothing is preserved.
}
\description{
Provides the raw data and plots a frequency distibution for Hounsfield Units in the entire core, also delineating material classes.
}
\examples{
# data(core_426)
coreHist("core_426", returnData = FALSE)

}
