% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extra_functions.R
\name{Var.data.cc}
\alias{Var.data.cc}
\title{Variance of the estimated effect size for case-control data}
\usage{
Var.data.cc(f, N, s)
}
\arguments{
\item{f}{Minor allele frequencies}

\item{N}{Total sample size (N0+N1)}

\item{s}{Proportion of cases (N1/N0+N1)}
}
\value{
Variance of estimated effect size \eqn{\hat{\beta}}, V.
}
\description{
Variance of the estimated effect size for case-control data
}
\examples{

maf =  runif(100, 0.05, 0.5)
N0 = 5000 # number of controls
N1 = 5000 # number of cases

Var.data.cc(f = maf, N = N0 + N1, s = N1/(N0+N1))

}
\author{
Chris Wallace
}
