% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SBS96_ID_to_SBS192_ID.R
\name{SBS96_ID_to_SBS192_ID}
\alias{SBS96_ID_to_SBS192_ID}
\title{Translate SBS96 signature IDs to SBS192 signature IDs by adding "-E" if necessary}
\usage{
SBS96_ID_to_SBS192_ID(sig_ids)
}
\arguments{
\item{sig_ids}{Character vector of SBS96 signature IDs.}
}
\value{
Character vector of corresponding SBS192 signature IDs; some
have "-E" (for exome) post-pended.
}
\description{
"-E" added to the name of a transcriptional strand bias
signature indicates that it was extracted only from exome sequencing data,
and thus reflects transcriptional strand bias in the exome rather than in
the entire transcript, including introns.
}
\examples{
sbs96_ids <- c("SBS1", "SBS23", "SBS25")
sbs192_ids <- SBS96_ID_to_SBS192_ID(sbs96_ids)
}
