% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refresh_covid19nytimes.R
\name{refresh_covid19nytimes_counties}
\alias{refresh_covid19nytimes_counties}
\title{US County Data from the NY Times}
\source{
New York Times, "We’re Sharing Coronavirus Case Data for Every U.S. County" \href{https://www.nytimes.com/article/coronavirus-county-data-us.html}{article} and {https://github.com/nytimes/covid-19-data}{data repository}

\href{https://github.com/Covid19R/documentation}{covid19R documentation}
}
\usage{
refresh_covid19nytimes_counties()
}
\value{
A tibble object
\itemize{
\item date - The date in YYYY-MM-DD form
\item location - The name of the location as provided by the data source. The counties dataset provides county and state. They are combined and separated by a \verb{,}, and can be split by \code{tidyr::separate()}, if you wish.
\item location_type - The type of location using the covid19R controlled vocabulary.
\item location_code - A standardized location code using a national or international standard. In this case, FIPS state or county codes. See https://en.wikipedia.org/wiki/Federal_Information_Processing_Standard_state_code and https://en.wikipedia.org/wiki/FIPS_county_code for more
\item location_code_type The type of standardized location code being used according to the covid19R controlled vocabulary. Here we use \code{fips_code}
\item data_type - the type of data in that given row. Includes \code{total_cases} and \code{total_deaths}, cumulative measures of both.
\item value - number of cases of each data type
}
}
\description{
Update the county-level data from the New York Times on Covid-19
}
\details{
Pulls from the open source data at https://www.nytimes.com/article/coronavirus-county-data-us.html
including cumulative cases and deaths. Returns the data in the covid19R standard tidy format for easy use.
Location data is returned as \verb{County,State}.
See https://github.com/nytimes/covid-19-data for extensive methodology description and license. Please
follow the license guidelines at https://github.com/nytimes/covid-19-data/blob/master/LICENSE if you plan
to use the data for public display.
}
\examples{
\dontrun{
# update the data
covid19nytimes_counties <- refresh_covid19nytimes_counties()
}

}
