% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_national_data.R
\name{get_national_data}
\alias{get_national_data}
\title{Get national-level data for countries globally, sourced from the ECDC or WHO.}
\usage{
get_national_data(
  countries,
  source = "who",
  totals = FALSE,
  steps = FALSE,
  class = FALSE,
  verbose = TRUE,
  country = deprecated(),
  ...
)
}
\arguments{
\item{countries}{A character vector specifying country names of interest.
Used to filter the data.}

\item{source}{A character string specifying the data source (not case
dependent). Defaults to WHO (the World Health Organisation). See
\code{get_available_datasets("natioanl")} for all options.}

\item{totals}{Logical, defaults to FALSE. If TRUE, returns totalled
data per region up to today's date. If FALSE, returns the full dataset
stratified by date and region.}

\item{steps}{Logical, defaults to FALSE. Should all processing and cleaning
steps be kept and output in a list.}

\item{class}{Logical, defaults to FALSE. If TRUE returns the
\code{DataClass} object rather than a tibble or a list of tibbles.
Overrides \code{steps}.}

\item{verbose}{Logical, defaults to \code{TRUE}. Should verbose processing
messages and warnings be returned.}

\item{country}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} A character string
specifying a country to filter for.}

\item{...}{Additional arguments to pass to class specific functionality.}
}
\value{
A tibble with data related to cases, deaths, hospitalisations,
recoveries and testing.
}
\description{
Gets raw data using the source-specific function. Includes ISO
country codes. Then adds columns which were missing from the raw data
(calculating cumulative counts from new dailies and vice versa), cleans
and sanitises further. Adds rows and columns of NA values so that data is
in a standard format.
}
\examples{
\dontrun{
# set up a data cache
start_using_memoise()

# download data for Canada keeping all processing steps
get_national_data(countries = "canada", source = "ecdc", steps = TRUE)
}
}
