crew_test("relay start, terminate, validate", {
  x <- crew_relay()
  expect_silent(x$validate())
  expect_null(x$condition)
  x$start()
  expect_silent(x$validate())
  expect_true(inherits(x$condition, "conditionVariable"))
  x$terminate()
  expect_silent(x$validate())
  expect_null(x$condition)
})

crew_test("relay and waiting", {
  x <- crew_relay()
  x$set_from(nanonext::cv())
  x$set_to(nanonext::cv())
  x$start()
  expect_silent(x$validate())
  nanonext::cv_signal(x$from)
  nanonext::msleep(250)
  throttle <- crew_throttle()
  expect_equal(nanonext::cv_value(x$from), 1L)
  expect_equal(nanonext::cv_value(x$condition), 1L)
  expect_equal(nanonext::cv_value(x$to), 1L)
  expect_true(x$wait(throttle = throttle))
  expect_equal(nanonext::cv_value(x$from), 1L)
  expect_equal(nanonext::cv_value(x$condition), 0L)
  expect_equal(nanonext::cv_value(x$to), 1L)
  expect_false(x$wait(throttle = throttle))
  expect_equal(nanonext::cv_value(x$from), 1L)
  expect_equal(nanonext::cv_value(x$condition), 0L)
  expect_equal(nanonext::cv_value(x$to), 1L)
})
