% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_player_meta.R
\name{update_player_meta}
\alias{update_player_meta}
\title{Update player_meta}
\usage{
update_player_meta(start_again = FALSE)
}
\arguments{
\item{start_again}{If TRUE, downloads all data from ESPNCricinfo without
using player_meta as a starting point. This can take a long time.}
}
\value{
A tibble containing meta data on cricket players.
}
\description{
The \link{player_meta} data set contains the names and other
attributes of players who appear on both \href{https://cricsheet.org}{cricsheet}
and \href{https://www.espncricinfo.com}{ESPNCricinfo} as at 20 January 2023.
This function returns an updated version of the data set based on information
currently available online.
}
\examples{
\dontrun{
# Update data to current
new_player_meta <- update_player_meta()
}
}
\seealso{
\link{player_meta}, \code{\link[=fetch_player_meta]{fetch_player_meta()}}.
}
\author{
Hassan Rafique and Rob J Hyndman
}
