% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_hdbscan_haplotyping.R
\name{run_hdbscan_haplotyping}
\alias{run_hdbscan_haplotyping}
\title{Cluster SNPs with HDBSCAN and identify haplotypes}
\usage{
run_hdbscan_haplotyping(
  vcf,
  LD,
  pheno,
  MGmin,
  minHap = 5,
  hetmiss_as = "allele",
  metadata = NULL,
  keep_outliers = FALSE
)
}
\arguments{
\item{vcf}{Input VCF for region of interest.}

\item{LD}{Pairwise correlation matrix of SNPs in region (e.g. from PLINK).}

\item{pheno}{Input numeric phenotype data for each individual.}

\item{MGmin}{Minimum SNPs in marker groups, MinPts parameter for DBscan.}

\item{minHap}{Minimum nIndividuals in a haplotype combination.}

\item{hetmiss_as}{If hetmiss_as = "allele", heterozygous-missing SNPs './N'
are recoded as 'N/N', if hetmiss_as = "miss", the site is recoded as missing.}

\item{metadata}{Metadata input (optional).}

\item{keep_outliers}{When FALSE, marker group smoothing is performed to
remove outliers.}
}
\value{
A comprehensive haplotyping S3 object (HapObject) for each provided
epsilon value, needed for clustree_viz() and crosshap_viz().
}
\description{
run_hdbscan_haplotyping() performs HDBSCAN clustering of SNPs in region of
interest to identify marker groups. Individuals are classified by haplotype
combination based on shared combinations of marker group alleles. Returns a
comprehensive haplotyping object (HapObject), which can be visualized with reference
to phenotype and metadata using crosshap_viz() (set epsilon to 1 as a dummy value).
}
