% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.R
\docType{data}
\name{iris2}
\alias{iris2}
\title{Modified \code{iris} dataset}
\format{
A data frame with 150 observations on 5 variables with labels.
}
\source{
\preformatted{
library(dplyr)
iris2 = iris \%>\% 
    mutate_at("Species", factor) \%>\% 
    expss::apply_labels( #I also could have used [import_labels] or even `labelled::set_variable_labels()`
        Species = "Specie",
        Sepal.Length = "Length of Sepal",
        Sepal.Width = "Width of Sepal",
        Petal.Length = "Length of Petal",
        Petal.Width = "Width of Petal"
    ) \%>\% 
    as_tibble()
}
}
\usage{
iris2
}
\description{
Modified \code{iris} dataset so:
\itemize{
\item every column is labelled (using \code{label} attribute)
\item \code{Species} column is considered as factor
}

See \code{\link{iris}} for more informations on the original "Edgar Anderson's Iris Data" dataset.
}
\examples{
library(crosstable)
ct=crosstable(iris2, by=Species)
ct
as_flextable(ct)
}
\keyword{datasets}
