% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asyncvaried.R
\docType{data}
\name{AsyncVaried}
\alias{AsyncVaried}
\title{Async client for different request types}
\arguments{
\item{..., .list}{Any number of objects of class \code{\link{HttpRequest}},
must supply inputs to one of these parameters, but not both}
}
\value{
An object of class \code{AsyncVaried} with variables and methods
}
\description{
Async client for different request types
}
\details{
\strong{Methods}
  \describe{
    \item{\code{request()}}{
      execute asynchronous requests
    }
    \item{\code{requests()}}{
      list requests
    }
    \item{\code{parse(encoding = "UTF-8")}}{
      parse content
    }
    \item{\code{status_code()}}{
      (integer) HTTP status codes
    }
    \item{\code{status()}}{
      (list) HTTP status objects
    }
    \item{\code{content()}}{
      raw content
    }
    \item{\code{times()}}{
      curl request times
    }
  }
}
\examples{
\dontrun{
# pass in requests via ...
req1 <- HttpRequest$new(
  url = "https://httpbin.org/get",
  opts = list(verbose = TRUE),
  headers = list(foo = "bar")
)$get()
req2 <- HttpRequest$new(url = "https://httpbin.org/post")$post()
out <- AsyncVaried$new(req1, req2)
out$request()
out$status()
out$status_code()
out$content()
out$times()
out$parse()
out$responses()

# pass in requests in a list via .list param
reqlist <- list(
  HttpRequest$new(url = "https://httpbin.org/get")$get(),
  HttpRequest$new(url = "https://httpbin.org/post")$post(),
  HttpRequest$new(url = "https://httpbin.org/put")$put(),
  HttpRequest$new(url = "https://httpbin.org/delete")$delete(),
  HttpRequest$new(url = "https://httpbin.org/get?g=5")$get(),
  HttpRequest$new(
    url = "https://httpbin.org/post")$post(body = list(y = 9)),
  HttpRequest$new(
    url = "https://httpbin.org/get")$get(query = list(hello = "world"))
)

out <- AsyncVaried$new(.list = reqlist)
out$request()
out$status()
out$status_code()
out$content()
out$times()
out$parse()
}
}
\seealso{
Other async: \code{\link{Async}}
}
\keyword{datasets}
