% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paginator.R
\docType{data}
\name{Paginator}
\alias{Paginator}
\title{Paginator client}
\arguments{
\item{client}{an object of class \code{HttpClient}, from a call to \link{HttpClient}}

\item{by}{(character) how to paginate. Only 'query_params' supported for
now. In the future will support 'link_headers' and 'cursor'. See Details.}

\item{limit_param}{(character) the name of the limit parameter.
Default: limit}

\item{offset_param}{(character) the name of the offset parameter.
Default: offset}

\item{limit}{(numeric/integer) the maximum records wanted}

\item{limit_chunk}{(numeric/integer) the number by which to chunk requests,
e.g., 10 would be be each request gets 10 records}

\item{progress}{(logical) print a progress bar, using \link[utils:txtProgressBar]{utils::txtProgressBar}.
Default: \code{FALSE}.}
}
\value{
a list, with objects of class \code{\link[=HttpResponse]{HttpResponse()}}.
Responses are returned in the order they are passed in.
}
\description{
A client to help you paginate
}
\details{
\strong{Methods}
\describe{
\item{\code{get(path, query, ...)}}{
make a paginated GET request
}
\item{\code{post(path, query, body, encode, ...)}}{
make a paginated POST request
}
\item{\code{put(path, query, body, encode, ...)}}{
make a paginated PUT request
}
\item{\code{patch(path, query, body, encode, ...)}}{
make a paginated PATCH request
}
\item{\code{delete(path, query, body, encode, ...)}}{
make a paginated DELETE request
}
\item{\code{head(path, ...)}}{
make a paginated HEAD request - not sure if this makes any sense
or not yet
}
\item{\code{responses()}}{
list responses
- returns: a list of \code{HttpResponse} objects, empty list before
requests made
}
\item{\code{parse(encoding = "UTF-8")}}{
parse content
- returns: character vector, empty character vector before
requests made
}
\item{\code{status_code()}}{
(integer) HTTP status codes
- returns: numeric vector, empty numeric vector before
requests made
}
\item{\code{status()}}{
(list) HTTP status objects
- returns: a list of \code{http_code} objects, empty list before
requests made
}
\item{\code{content()}}{
raw content
- returns: raw list, empty list before requests made
}
\item{\code{times()}}{
curl request times
- returns: list of named numeric vectors, empty list before
requests made
}
\item{\code{url_fetch(path, query)}}{
get URLs that would be sent (i.e., before executing the request).
the only things that change the URL are path and query
parameters; body and any curl options don't change the URL
- returns: character vector of URLs
}
}

See \code{\link[=HttpClient]{HttpClient()}} for information on parameters.
}
\section{Methods to paginate}{


Supported now:
\itemize{
\item \code{query_params}: the most common way, so is the default. This method
involves setting how many records and what record to start at for each
request. We send these query parameters for you.
}

Supported later:
\itemize{
\item \code{link_headers}: link headers are URLS for the next/previous/last
request given in the response header from the server. This is relatively
uncommon, though is recommended by JSONAPI and is implemented by a
well known API (GitHub).
\item \code{cursor}: this works by a single string given back in each response, to
be passed in the subsequent response, and so on until no more records
remain. This is common in Solr
}
}

\examples{
\dontrun{
(cli <- HttpClient$new(url = "https://api.crossref.org"))
cc <- Paginator$new(client = cli, limit_param = "rows",
   offset_param = "offset", limit = 50, limit_chunk = 10)
cc
cc$get('works')
cc
cc$responses()
cc$status()
cc$status_code()
cc$times()
cc$content()
cc$parse()
lapply(cc$parse(), jsonlite::fromJSON)

# get full URLs for each request to be made
cc$url_fetch('works')
cc$url_fetch('works', query = list(query = "NSF"))

# progress bar
(cli <- HttpClient$new(url = "https://api.crossref.org"))
cc <- Paginator$new(client = cli, limit_param = "rows",
   offset_param = "offset", limit = 50, limit_chunk = 10, 
   progress = TRUE)
cc
cc$get('works')
}
}
\keyword{datasets}
