% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-datasets.R
\name{loadDataset}
\alias{loadDataset}
\title{Load a Crunch Dataset}
\usage{
loadDataset(dataset, kind = c("active", "all", "archived"),
  project = NULL, refresh = FALSE)
}
\arguments{
\item{dataset}{character, the name of a Crunch dataset that you have access
to, or a \code{DatasetTuple}.}

\item{kind}{character specifying whether to look in active, archived, or all
datasets. Default is "active", i.e. non-archived.}

\item{project}{\code{CrunchProject} entity, character name of a project, or
\code{NULL}, the default. If a Project entity or reference is supplied, the
function will display datasets from that Project's datasets. If \code{NULL},
the primary dataset catalog for the user will be used.}

\item{refresh}{logical: should the function check the Crunch API for new
datasets? Default is \code{FALSE}.}
}
\value{
An object of class \code{CrunchDataset}
}
\description{
Load a Crunch Dataset
}
\examples{
\dontrun{
dsName <- listDatasets()[1]
ds <- loadDatasets(dsName)
}
}
