% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user.R
\name{reassignUser}
\alias{reassignUser}
\title{Reassign all Crunch objects from a user}
\usage{
reassignUser(from, to)
}
\arguments{
\item{from}{a character of the email address of the user to reassign from}

\item{to}{a character of the email address of the user who should be the new
owner}
}
\value{
\code{NULL} if successful
}
\description{
If you want to transfer all teams, projects, and datasets owned by one user
to another you can with \code{reassignUser}. To have permission to use
\code{reassignUser} you must be an account admin and be from the same account
as the user who is being reassigned. This is useful if a user leaves your
organization and you want to transfer all of the teams, projects, and
datasets they own to someone else.
}
\details{
The user given in \code{to} will become the owner of all of the teams, projects,
and datasets that were previously owned by the user given in \code{from}.

Reassigning requires confirmation. In an interactive session, you will be
asked to confirm. To avoid that prompt, or to reassign datasets from a
non-interactive session, wrap the call in \code{\link[=with_consent]{with_consent()}} to give your
permission to reassign
}
