% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/folders.R
\name{rmdir}
\alias{rmdir}
\title{Delete a folder}
\usage{
rmdir(x, path)
}
\arguments{
\item{x}{A \code{CrunchDataset} or \code{Folder} (\code{VariableFolder} or \code{ProjectFolder})}

\item{path}{A character "path" to the folder: either a
vector of nested folder names or a single string with nested folders
separated by a delimiter ("/" default, configurable via
\code{options(crunch.delimiter)}). The path is interpreted as
relative to the location of the folder \code{x} (when \code{x} is a dataset, that
means the root, top-level folder). \code{path} may also be a \code{Folder} object.}
}
\value{
\code{NULL}
}
\description{
Like \code{rmdir} in a file system, this function removes a folder. Unlike the
file-system version, it does not require the folders to be empty.
}
\examples{
\dontrun{
ds <- loadDataset("Example survey")
rmdir(ds, "Demographics")
# Or with \%>\%
require(magrittr)
ds <- ds \%>\%
    rmdir("Demographics")
}
}
\seealso{
\code{\link[=mv]{mv()}} to move entities to a folder; \code{\link[=cd]{cd()}} to select a folder;
\code{\link[base:files]{file.remove()}} if you literally want to delete a directory
from your local file system, which \code{rmdir()} does not do
}
