#' Continuous-time multivariate analysis
#'
#' Implements continuous-time analogues of several classical techniques of multivariate analysis.
#' The inputs are \code{"\link[fda]{fd}"} (functional data) objects from the \pkg{fda} package.
#'
#' @name ctmva-package
#' @aliases ctmva-package ctmva
#' @docType package
#'
#' @author Biplab Paul <paul.biplab497@gmail.com> and Philip Tzvi Reiss <reiss@stat.haifa.ac.il>
#'
#' @references Reiss, Philip T. and Paul, Biplab (2022). Continuous-time multivariate analysis. Preprint.
#' @references Ramsay, James O. and Silverman, Bernard W. (2005). Functional Data Analysis, 2nd ed., Springer, New York.
#' @references Ramsay, J. O.; Hooker, Giles and Graves, Spencer (2009). Functional Data Analysis with R and Matlab, Springer, New York.
#' 
#' @keywords package
#'
#' @importFrom fda fd eval.basis eval.fd
#' @importFrom graphics abline legend matplot mtext
#' @importFrom stats as.formula lm runif

NULL



