% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dbGetFieldsIntoDf}
\alias{dbGetFieldsIntoDf}
\title{Create data frame by extracting specified fields from database collection}
\usage{
dbGetFieldsIntoDf(fields = "", con, verbose = FALSE, stopifnodata = TRUE)
}
\arguments{
\item{fields}{Vector of one or more strings, with names of the sought fields.
See function \link{dbFindFields} for how to find names of fields.
Regular expressions are possible. "item.subitem" notation is supported.}

\item{con}{A \link[nodbi]{src} connection object, as obtained with
nodbi::\link[nodbi]{src_mongo}() or nodbi::\link[nodbi]{src_sqlite}()}

\item{verbose}{Printing additional information if set to \code{TRUE};
default is \code{FALSE}.}

\item{stopifnodata}{Stops with an error (\code{TRUE}, default) or with
a warning (\code{FALSE}) if the sought field is empty in all,
or not available in any of the records in the database collection.}
}
\value{
A data frame with columns corresponding to the sought fields.
Note: a column for the record _id will always be included.
Each column can be either a simple data type (numeric, character, date)
or a list (see example below): For complicated lists, use function
\link{dfTrials2Long} followed by function \link{dfName2Value} to
extract values for nested variables.
The maximum number of rows of the returned data frame is equal to,
or less than the number of records of trials in the database.
}
\description{
With this convenience function, fields in the database are retrieved
into an R data frame. Note that fields within the record of a trial
can be hierarchical and structured, that is, nested.
}
\details{
With both src_sqlite and src_mongo, the function returns a list of data
for a field that includes nested content; use function
\link{dfTrials2Long} followed by \link{dfName2Value} to
extract desired nested variables.

For more sophisticated data retrieval from the database, see vignette
examples and other packages to query mongodb such as mongolite.
}
\examples{

\dontrun{
db <- nodbi::src_sqlite(
  collection = "my_collection"
)

# access fields that are nested within another field
# and can have multiple values with the other field
dbGetFieldsIntoDf(
  "b1_sponsor.b31_and_b32_status_of_the_sponsor",
  con = db
)[1,]
#                 _id b1_sponsor.b31_and_b32_status_of_the_sponsor
# 1 2004-000015-25-GB                  Non-commercial / Commercial

# access fields that include a list of values
# which are printed as comma separated values
dbGetFieldsIntoDf(
  "keyword",
  con = db
)[1,]

#           _id                                 keyword
# 1 NCT00129259 T1D, type 1 diabetes, juvenile diabetes

str(.Last.value)
# 'data.frame':	1 obs. of  2 variables:
# $ _id    : chr "NCT00129259"
# $ keyword:List of 1
# ..$ : chr  "T1D" "type 1 diabetes" "juvenile diabetes"

}

}
