% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctStanGenerate.R
\name{ctStanGenerate}
\alias{ctStanGenerate}
\title{Generate data from a ctstanmodel object}
\usage{
ctStanGenerate(
  ctm,
  datastruct,
  optimize = TRUE,
  is = FALSE,
  fullposterior = TRUE,
  nsamples = 200,
  parsonly = FALSE,
  ...
)
}
\arguments{
\item{ctm}{\code{\link{ctStanModel}} object.}

\item{datastruct}{long format data structure as used by ctsem.}

\item{optimize}{Whether to optimize or use Stan's HMC sampler}

\item{is}{If optimizing, follow up with importance sampling?}

\item{fullposterior}{Generate from the full posterior or just the mean?}

\item{nsamples}{How many samples to generate?}

\item{parsonly}{If TRUE, only return samples of raw parameters, don't generate data.}

\item{...}{arguments to pass to stanoptimis}
}
\value{
Array of nsamples x time points x manifest variables.
}
\description{
Generate data from a ctstanmodel object
}
\examples{
\dontrun{
m1 <- ctModel(type = 'stanct',
manifestNames = c('Exercise1'), 
latentNames=c('Exercise'),
DRIFT= 0,
DIFFUSION=0,
CINT='cint1',
T0MEANS='t0m1',
T0VAR=0, #only need to set this when t0means not individually varying
LAMBDA = 1,
MANIFESTMEANS=0,
MANIFESTVAR='merror')


#generate and plot samples from prior predictive
priorpred <- ctStanGenerate(ctm = m1,datastruct = exfitdat,cores=6,nsamples = 50)
}
}
