% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-key.R
\name{check_key}
\alias{check_key}
\title{Check on key when create cubble from two components (spatial/temporal)}
\usage{
check_key(spatial, temporal, by = NULL)
}
\arguments{
\item{spatial}{a tibble object or an sf object, the spatial component
containing the \code{key} and \code{coords} variable (\code{coords} can be automatically
created from an \code{sf} object if not supplied).}

\item{temporal}{a tibble object or a tsibble object, the temporal component
containing the \code{key} and \code{index} variable.}

\item{by}{in the syntax of the \code{by} argument in \code{\link[dplyr:mutate-joins]{dplyr::left_join()}},
used in \code{make_cubble()} when the key variable has different names in the
\code{spatial} and \code{temporal} data.}
}
\value{
a list with three elements: 1) paired: a tibble of paired ID from
spatial and temporal data, 2) potential_pairs: a tibble of pairs that could
potentially match from both datasets, 3) others: other key values that can't
be matched in a list: others$temporal and others$spatial
}
\description{
When creating a cubble from separate spatial and temporal component,
\code{\link[=make_cubble]{make_cubble()}} will informed users about potential disagreement
of the key values in the two datasets (some sites appear in one table
but not the other). This function summarises the key values into those
match, potentially can be matched, and can't be matched.
}
\examples{
check_key(stations, meteo)

# make_cubble() will prompt to use check_key if there are key mis-match:
colnames(lga) <- c("lga", "geometry")
cb <- make_cubble(spatial = lga, temporal = covid)
(check_res <- check_key(lga, covid))
make_cubble(spatial = lga, temporal = covid, potential_match = check_res)
}
