\name{pmeans.hcoef}
\alias{pmeans.hcoef}
\concept{MCMC}
\concept{hierarchical model}
\title{Posterior mean for each regression variable}
\description{
  \code{pmeans.hcoef} processes the MCMC simulation to evaluate the posterior mean of the regression variables.}
\usage{
pmeans.hcoef(x,burnin=trunc(.1*R))}
\arguments{
  \item{x}{\samp{betadraw} object generated by the MCMC simulation}
  \item{burnin}{n. of draws to burnin, def: .1*R}
}
\value{
  \item{pmeans}{Posterior Means of Coefficients}}
\details{Post-process MCMC simulation}
\seealso{
  \code{\link{cudaMultireg.slice}},
  \code{\link{read.fmrislice}},
  \code{\link{regpostsim}},
  \code{\link{post.simul.betadraw}},
  \code{\link{post.simul.hist}}
}
\examples{
\dontrun{
slicedata <- read.fmrislice(fbase="fmri", slice=3, swap=TRUE)
 ymaskdata <- premask(slicedata)
fsave <- "/tmp/simultest1.sav"
answ <- readline("Run MCMC simulation first ? ")
run <- FALSE
if (substr(answ, 1, 1) == "y") { run <- TRUE }
if(run) {
	out <- cudaMultireg.slice(slicedata, ymaskdata, R=2000, keep=5, nu.e=3, fsave=fsave,
		zprior=FALSE)
} else {
	load(file=fsave)
	cat("loaded",fsave,"\n")
}
pmeans <- pmeans.hcoef(out$betadraw)
}
}
\keyword{ utilities }
