% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators.R
\name{spikedOperatorShrinkEst}
\alias{spikedOperatorShrinkEst}
\title{Operator Norm Shrinkage Estimator, Spiked Covariance Model}
\usage{
spikedOperatorShrinkEst(dat, p_n_ratio, num_spikes = NULL, noise = NULL)
}
\arguments{
\item{dat}{A numeric \code{data.frame}, \code{matrix}, or similar object.}

\item{p_n_ratio}{A \code{numeric} between 0 and 1 representing the asymptotic
ratio of the number of features, p, and the number of observations, n.}

\item{num_spikes}{A \code{numeric} integer equal to or larger than one which
providing the known number of spikes in the population covariance matrix.
Defaults to \code{NULL}, indicating that this value is not known and must
be estimated.}

\item{noise}{A \code{numeric} representing the known scalar multiple of the
identity matrix giving the approximate population covariance matrix.
Defaults to \code{NULL}, indicating that this values is not known and must
be estimated.}
}
\value{
A \code{matrix} corresponding to the covariance matrix estimate.
}
\description{
\code{spikedOperatorShrinkEst()} implements the asymptotically
optimal shrinkage estimator with respect to the operator loss in a spiked
covariance matrix model. Informally, this model admits Gaussian
data-generating processes whose covariance matrix is a scalar multiple of
the identity, save for a few number of large "spikes". A thorough review of
this estimator, or more generally spiked covariance matrix estimation, is
provided in \insertCite{donoho2018;textual}{cvCovEst}.
}
\examples{
spikedOperatorShrinkEst(dat = mtcars, p_n_ratio = 0.1, num_spikes = 2L)

}
\references{
\insertAllCited{}
}
