% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cqv_versatile.R
\name{cqv_versatile}
\alias{cqv_versatile}
\title{Coefficient of Quartile Variation (cqv)}
\arguments{
\item{x}{An \code{R} object. Currently there are methods for numeric vectors}

\item{na.rm}{a logical value indicating whether \code{NA} values should be
stripped before the computation proceeds.}

\item{digits}{integer indicating the number of decimal places to be used.}

\item{method}{a scalar representing the type of confidence intervals
required. The value should be any of the values "bonett", "norm", "basic",
"perc", "bca" or "all".}

\item{R}{integer indicating the number of bootstrap replicates.}
}
\value{
An object of type "list" which contains the estimate, the intervals,
  and the computation method. It has two components:

\describe{ \item{$method}{ A description of statistical method used
  for the computations. } \item{$statistics}{ A data frame representing three
  vectors: est, lower and upper limits of 95\% confidence interval
  \code{(CI)}: \cr \cr \strong{est:}{ \code{cqv*100} } \cr \cr \strong{Bonett
  95\% CI:}{ It uses a centering adjustment which helps to equalize the tail
  error probabilities \code{[1, 2]}. } \cr \cr \strong{Normal approximation
  95\% CI:}{ The intervals calculated by the normal approximation \code{[3,
  4]}, using \link[boot]{boot.ci}. } \cr \cr \strong{Basic bootstrap 95\%
  CI:}{ The intervals calculated by the basic bootstrap method \code{[3, 4]},
  using \link[boot]{boot.ci}. } \cr \cr \strong{Bootstrap percentile 95\%
  CI:}{ The intervals calculated by the bootstrap percentile method \code{[3,
  4]}, using \link[boot]{boot.ci}. } \cr \cr \strong{Adjusted bootstrap
  percentile (BCa) 95\% CI:}{ The intervals calculated by the adjusted
  bootstrap percentile (BCa) method \code{[3, 4]}, using
  \link[boot]{boot.ci}. } } }
}
\description{
Versatile function for the coefficient of quartile variation
  (cqv)
}
\details{
\describe{ \item{\strong{Coefficient of Quartile Variation}}{ The
  \emph{cqv} is a measure of relative dispersion that is based on
  interquartile range \emph{(iqr)}. Since \eqn{cqv} is unitless, it is useful
  for comparison of variables with different units. It is also a measure of
  homogeneity \code{[1, 2]}. } }
}
\examples{
x <- c(
    0.2, 0.5, 1.1, 1.4, 1.8, 2.3, 2.5, 2.7, 3.5, 4.4,
    4.6, 5.4, 5.4, 5.7, 5.8, 5.9, 6.0, 6.6, 7.1, 7.9
)
cqv_versatile(x)
cqv_versatile(x, na.rm = TRUE, digits = 2)
cqv_versatile(x, na.rm = TRUE, digits = 2, method = "bonett")
}
\references{
\code{[1]} Bonett, DG., 2006, Confidence interval for a
  coefficient of quartile variation, Computational Statistics & Data
  Analysis, 50(11), 2953-7, DOI:
  \href{http://doi.org/10.1016/j.csda.2005.05.007}{http://doi.org/10.1016/j.csda.2005.05.007}

\code{[2]} Altunkaynak, B., Gamgam, H., 2018, Bootstrap
  confidence intervals for the coefficient of quartile variation, Simulation
  and Computation, 1-9, DOI:
  \href{http://doi.org/10.1080/03610918.2018.1435800}{http://doi.org/10.1080/03610918.2018.1435800}

\code{[3]} Canty, A., & Ripley, B, 2017, boot: Bootstrap R
  (S-Plus) Functions. R package version 1.3-20.

\code{[4]} Davison, AC., & Hinkley, DV., 1997, Bootstrap Methods
  and Their Applications. Cambridge University Press, Cambridge. ISBN
  0-521-57391-2
}
