% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cxreg-package.R
\name{cxreg-package}
\alias{cxreg-package}
\title{Complex-valued Lasso and graphical Lasso paths}
\description{
This package fits complex-valued Lasso for regression using coordinate descent. The algorithm is extremely fast, and exploits sparsity in the input x matrix where it exists.
A variety of predictions can be made from the fitted models.
}
\details{
This package also provides fitting for complex-valued graphical Lasso using coordinate descent.
The function is built upon classo with covariate updates, just as the regular real-valued coordinate descent algorithm for graphical Lasso.

\tabular{ll}{
Package: \tab cxreg \cr
Type: \tab Package \cr
Version: \tab 1.0.0 \cr
Date: \tab 2025-07-01 \cr
License: \tab MIT + file LICENSE \cr
}

Very simple to use. Accepts \code{x,y} data for penalized regression models, and
produces the regularization paths over a grid of values for the tuning
parameters \code{lambda}. Similarly, accepts \code{S,n} data for penalized Gaussian likelihood,
and produce the regularization paths over a grid of values for the tuning parameter \code{lambda}.
}
\examples{
\donttest{ 
set.seed(1234)
x <- array(rnorm(100*20), c(100,20)) + (1+1i) * array(rnorm(100*20), c(100,20))
for (j in 1:20) x[,j] <- x[,j] / sqrt(mean(Mod(x[,j])^2))
e <- rnorm(100) + (1+1i) * rnorm(100)
b <- c(1, -1, rep(0, 18)) + (1+1i) * c(-0.5, 2, rep(0, 18))
y <- x \%*\% b + e
fit <- classo(x, y)
predict(fit, newx = x[1:5, ], s = c(0.01, 0.005))
predict(fit, type = "coef")
plot(fit, xvar = "lambda")
}

\donttest{ 
p <- 30
n <- 500
C <- diag(0.7, p)
C[row(C) == col(C) + 1] <- 0.3  
C[row(C) == col(C) - 1] <- 0.3  
Sigma <- solve(C)
set.seed(1010)
m <- floor(sqrt(n)); j <- 1
X_t <- mvtnorm::rmvnorm(n = n, mean = rep(0, p), sigma = Sigma)
d_j <- dft.X(X_t,j,m)
f_j_hat <- t(d_j) \%*\% Conj(d_j) / (2*m+1)
fit <- cglasso(S=f_j_hat, nobs=n,type="I")
plot(fit$Theta_list,index=fit$min_index,type="mod",label=FALSE)
}
}
\references{
Deb, N., Kuceyeski, A., Basu, S. (2024)
\emph{Regularized Estimation of Sparse Spectral Precision Matrices},
\url{https://arxiv.org/abs/2401.11128}.
}
\author{
Younghoon Kim, Navonil Deb, Sumanta Basu \cr Maintainer:
Younghoon Kim \href{mailto:yk748@cornell.edu}{yk748@cornell.edu}
}
\keyword{models}
\keyword{package}
\keyword{regression}
