% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/party.R
\name{d3_party}
\alias{d3_party}
\title{Convert partykit to d3.js hierarchy}
\usage{
d3_party(tree = NULL, json = TRUE)
}
\arguments{
\item{tree}{\code{partykit} object to be converted}

\item{json}{\code{logical} to return \code{list} or \code{json}}
}
\value{
\code{list} or \code{json} depending on \code{json} arg
}
\description{
This thing is not even close to being done, so please help
with ideas and contributions.
}
\examples{
\dontrun{

  library(d3r)
  # from ?rpart
  data("kyphosis", package="rpart")
  d3_party(
    rpart::rpart(Kyphosis ~ Age + Number + Start, data = kyphosis)
  )

  # if you want the list instead of json
  d3_party(
    rpart::rpart(Kyphosis ~ Age + Number + Start, data = kyphosis),
    json = FALSE
  )

  # with ctree instead of rpart
  #  using example from ?ctree
  d3_party(partykit::ctree(Species ~ .,data = iris))


  #devtools::install_github("timelyportfolio/d3treeR")

  library(d3treeR)

  d3tree2(
    d3_party(
      rpart::rpart(Kyphosis ~ Age + Number + Start, data = kyphosis)
    ),
    celltext = "rule",
    valueField = "n"
  )

}
}
