% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dagitty.r
\name{getExample}
\alias{getExample}
\title{Get Bundled Examples}
\usage{
getExample(x)
}
\arguments{
\item{x}{name of the example, or part thereof. Supported values are:
\itemize{
 \item{"M-bias"}{ the M-bias graph.}
 \item{"confounding"}{ an extended confounding triangle.}
 \item{"mediator"}{ a small model with a mediator.}
 \item{"paths"}{ a graph with many variables but few paths}
 \item{"Sebastiani"}{ a small part of a genetics study (Sebastiani et al., 2005)}
 \item{"Polzer"}{ DAG from a dentistry study (Polzer et al., 2012)}
 \item{"Schipf"}{ DAG from a study on diabetes (Schipf et al., 2010)}
 \item{"Shrier"}{ DAG from a classic sports medicine example (Shrier & Platt, 2008)}
 \item{"Thoemmes"}{ DAG with unobserved variables 
(communicated by Felix Thoemmes, 2013)}.
 \item{"Kampen"}{ DAG from a psychiatry study (van Kampen, 2014)}
}}
}
\description{
Provides access to the builtin examples of the dagitty website.
}
\examples{
g <- getExample("Shrier")
plot(g)

}
\references{
Sabine Schipf, Robin Haring, Nele Friedrich, Matthias Nauck, Katharina Lau,
Dietrich Alte, Andreas Stang, Henry Voelzke, and Henri Wallaschofski (2011),
Low total testosterone is associated with increased risk of incident
type 2 diabetes mellitus in men: Results from the study of health in
pomerania (SHIP). \emph{The Aging Male} \bold{14}(3):168--75.

Paola Sebastiani, Marco F. Ramoni, Vikki Nolan, Clinton T. Baldwin, and
Martin H. Steinberg (2005), Genetic dissection and prognostic modeling of overt 
stroke in sickle cell anemia. \emph{Nature Genetics}, \bold{37}:435--440.

Ian Shrier and Robert W. Platt (2008), 
Reducing bias through directed acyclic graphs.
\emph{BMC Medical Research Methodology}, \bold{8}(70).

Ines Polzer, Christian Schwahn, Henry Voelzke, Torsten Mundt, and Reiner
Biffar (2012), The association of tooth loss with all-cause and circulatory
 mortality. Is there a benefit of replaced teeth? A systematic review and
 meta-analysis. \emph{Clinical Oral Investigations}, \bold{16}(2):333--351.

Dirk van Kampen (2014),
The SSQ model of schizophrenic prodromal unfolding revised: An
 analysis of its causal chains based on the language of directed graphs.
\emph{European Psychiatry}, \bold{29}(7):437--48.
}
