% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dagitty.r
\name{lavaanToGraph}
\alias{lavaanToGraph}
\title{Convert Lavaan Model to DAGitty Graph}
\usage{
lavaanToGraph(x, digits = 3, ...)
}
\arguments{
\item{x}{data frame, lavaan parameter table such as returned by 
\code{\link[lavaan]{lavaanify}}. Can also be a \code{lavaan} object
or a lavaan model string.}

\item{digits}{number of significant digits to use when representing 
path coefficients, if any}

\item{...}{Not used.}
}
\description{
The \code{lavaan} package is a popular package for structural equation 
modeling. To provide interoperability with lavaan, this function 
converts models specified in lavaan syntax to dagitty graphs.
}
\examples{
if( require(lavaan) ){
mdl <- lavaanify("
X ~ C1 + C3
M ~ X + C3
Y ~ X + M + C3 + C5
C1 ~ C2
C3 ~ C2 + C4
C5 ~ C4
C1 ~~ C2 \n C1 ~~ C3 \n C1 ~~ C4 \n C1 ~~ C5
C2 ~~ C3 \n C2 ~~ C4 \n C2 ~~ C5
C3 ~~ C4 \n C3 ~~ C5",fixed.x=FALSE)
plot( lavaanToGraph( mdl ) )
}
}
