% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted.R
\name{fitted.dalmatian}
\alias{fitted.dalmatian}
\title{Prediction method for dalmatian Fitted Objects}
\usage{
\method{fitted}{dalmatian}(object, df = object$df, method = "mean",
  ci = TRUE, level = 0.95, ...)
}
\arguments{
\item{object}{Object of class \code{dalmatian} created by \code{dalmatian()}.}

\item{df}{data frame containing predictor values to predict response variables. Defaults to data in \code{object} if not supplied. (data.frame)}

\item{method}{Method to construct the fitted model. Either \code{"mean"} or \code{"mode"} (character)}

\item{ci}{returning credible intervals for predictions if TRUE (logical)}

\item{level}{level of credible intervals for predictions (numeric)}

\item{...}{Ignored}
}
\value{
predictions (list)
}
\description{
Prediction method for dalmatian Fitted Objects
}
\examples{

## Load pied flycatcher data
data(pied_flycatchers_1)

## Create variables bounding the true load
pfdata$lower=ifelse(pfdata$load==0,log(.001),log(pfdata$load-.049))
pfdata$upper=log(pfdata$load+.05)

## Add 'log(IVI)' variable in pfdata
pfdata$'log(IVI)' <- log(pfdata$IVI)

## Load output from previously run model
load(system.file("Pied_Flycatchers_1","pfresults.RData",package="dalmatian"))

## Compute fitted values 
pred.pfresults <- fitted(object = pfresults, 
                         df = pfdata,
                         method = "mean",
                         ci = TRUE,
                         level = 0.95)
}
