% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_sample.R
\name{k_fold}
\alias{k_fold}
\title{K-fold sampling}
\usage{
k_fold(obj, data, k)
}
\arguments{
\item{obj}{an object representing the sampling method}

\item{data}{dataset to be partitioned}

\item{k}{number of folds}
}
\value{
returns a list of \code{k} data frames
}
\description{
k-fold partition of a dataset using a sampling method
}
\examples{
#using random sampling
sample <- sample_random()

# preparing dataset into four folds
folds <- k_fold(sample, iris, 4)

# distribution of folds
tbl <- NULL
for (f in folds) {
 tbl <- rbind(tbl, table(f$Species))
}
head(tbl)
}
