% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/darchUnitFunctions.R
\name{linearUnit}
\alias{linearUnit}
\title{Linear unit function with unit derivatives.}
\usage{
linearUnit(input, ...)
}
\arguments{
\item{input}{Input for the activation function.}

\item{...}{Additional parameters, not used.}
}
\value{
A list with the linear activation in the first entry and the
derivative of the activation in the second entry.
}
\description{
The function calculates the activation of the units and returns a list, in
which the first entry is the linear activation of the units and the second
entry is the derivative of the transfer function.
}
\examples{
\dontrun{
data(iris)
model <- darch(Species ~ ., iris, darch.unitFunction = "linearUnit")
}
}
\seealso{
Other darch unit functions: \code{\link{exponentialLinearUnit}},
  \code{\link{maxoutUnit}},
  \code{\link{rectifiedLinearUnit}},
  \code{\link{sigmoidUnit}}, \code{\link{softmaxUnit}},
  \code{\link{softplusUnit}}, \code{\link{tanhUnit}}
}

