% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{dcpiechart}
\alias{dcpiechart}
\title{dcpiechart adds a pie chart to the dashboard}
\usage{
dcpiechart(x, title = paste(x, "pie chart"), spansize = 4, radius = 100,
  innerradius = 30, width = dashboard.env$outerwidth * spansize/12,
  height = 250)
}
\arguments{
\item{x}{column name of data frame \code{data} for drawing a pie chart}

\item{title}{character for the title of the generated pie chart}

\item{spansize}{integer between 1 to 12 for the width of the element in the web page}

\item{radius}{integer for the size of the radius in pixels of the pie chart}

\item{innerradius}{integer for the size of the inner radius in pixels of the pie chart}

\item{width}{integer for the width (in pixels) of the chart in the web page}

\item{height}{integer for the height (in pixels) of the chart in the web page}
}
\description{
\code{dcpiechart} generates a pie chart
}
\examples{
dashboard_open(data=iris) # other options: pathoutput=getwd() ...
dcpiechart(x=names(iris)[5])
dcbarchart(x=names(iris)[1] , gap=75)
dcpiechart(x=names(iris)[2])
dctable(index=names(iris)[5])
dashboard_launch(browse = FALSE) # Just generates files. Server is not launched
}

