% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sameShape.R
\name{sameShape}
\alias{sameShape}
\title{Give same shape}
\usage{
sameShape(dataSet, referenceSet, verbose = TRUE)
}
\arguments{
\item{dataSet}{Matrix, data.frame or data.table to transform}

\item{referenceSet}{Matrix, data.frame or data.table}

\item{verbose}{Should the algorithm talk? (logical, default to TRUE)}
}
\value{
Return \code{dataSet} transformed in order to make it have the same shape as
\code{referenceSet}
}
\description{
Transform \code{dataSet} into the same shape as \code{referenceSet}. Espacially this 
function will be usefull to make your test set have the same shape as your train set.
}
\details{
This function will make sure that \code{dataSet} and \code{referenceSet} 
\itemize{
   \item have the same class
   \item have exactly the same columns
   \item have columns with exactly the same class
   \item have factor factor with exactly the same levels
}
You should always use this function before applying your model on a new data set to make sure
that everything will go smoothly. But if this function change a lot of stuff you should have a 
look to your preparation process, there might be something wrong.
}
\examples{
\dontrun{
# Build a train and a test
data("messy_adult")
data("adult")
train <- messy_adult
test <- adult # So test will have missing columns

# Prepare them
train <- prepareSet(train, verbose = FALSE, key = "country")
test <- prepareSet(test, verbose = FALSE, key = "country")

# Give them the same shape
test <- sameShape(test, train)
# As one can see in log, a lot of small change had to be done. 
# This is an extreme case but you get the idea.
}
# "##NOT RUN:" mean that this example hasn't been run on CRAN since its long. But you can run it!
}
