% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recombine_combine.R
\name{combCollect}
\alias{combCollect}
\title{"Collect" Recombination}
\usage{
combCollect(...)
}
\arguments{
\item{\ldots}{Additional list elements that will be added to the returned object}
}
\description{
"Collect" recombination - collect the results into a local list of key-value pairs
}
\details{
\code{combCollect} is passed to the argument \code{combine} in \code{\link{recombine}}
}
\examples{
# Create a distributed data frame using the iris data set
bySpecies <- divide(iris, by = "Species")

# Function to calculate the mean of the petal widths
meanPetal <- function(x) mean(x$Petal.Width)

# Combine the results using rbind
combined <- recombine(addTransform(bySpecies, meanPetal), combine = combCollect)
class(combined)
combined

# A more concise (and readable) way to do it
bySpecies \%>\%
  addTransform(meanPetal) \%>\%
  recombine(combCollect)
}
\author{
Ryan Hafen
}
\seealso{
\code{\link{divide}}, \code{\link{recombine}}, \code{\link{combDdo}}, \code{\link{combDdf}}, \code{\link{combMeanCoef}}, \code{\link{combRbind}}, \code{\link{combMean}}
}

