% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agnostic_hexbin.R
\name{drHexbin}
\alias{drHexbin}
\title{HexBin Aggregation for Distributed Data Frames}
\usage{
drHexbin(data, xVar, yVar, by = NULL, xTransFn = identity,
  yTransFn = identity, xRange = NULL, yRange = NULL, xbins = 30,
  shape = 1, params = NULL, packages = NULL, control = NULL)
}
\arguments{
\item{data}{a distributed data frame}

\item{xVar, yVar}{names of the variables to use}

\item{by}{an optional variable name or vector of variable names by which to group hexbin computations}

\item{xTransFn, yTransFn}{a transformation function to apply to the x and y variables prior to binning}

\item{xRange, yRange}{range of x and y variables (can be left blank if summaries have been computed)}

\item{xbins}{the number of bins partitioning the range of xbnds}

\item{shape}{the shape = yheight/xwidth of the plotting regions}

\item{params}{a named list of objects external to the input data that are needed in the distributed computing (most should be taken care of automatically such that this is rarely necessary to specify)}

\item{packages}{a vector of R package names that contain functions used in \code{fn} (most should be taken care of automatically such that this is rarely necessary to specify)}

\item{control}{parameters specifying how the backend should handle things (most-likely parameters to \code{rhwatch} in RHIPE) - see \code{\link{rhipeControl}} and \code{\link{localDiskControl}}}
}
\value{
a "hexbin" object
}
\description{
Create "hexbin" object of hexagonally binned data for a distributed data frame.  This computation is division agnostic - it does not matter how the data frame is split up.
}
\examples{
# create dummy data and divide it
dat <- data.frame(
  xx = rnorm(1000),
  yy = rnorm(1000),
  by = sample(letters, 1000, replace = TRUE))
d <- divide(dat, by = "by", update = TRUE)
# compute hexbins on divided object
dhex <- drHexbin(d, xVar = "xx", yVar = "yy")
# dhex is equivalent to running on undivided data:
hexbin(dat$xx, dat$yy)
}
\author{
Ryan Hafen
}
\references{
Carr, D. B. et al. (1987) Scatterplot Matrix Techniques for Large \eqn{N}. \emph{JASA} \bold{83}, 398, 424--436.
}
\seealso{
\code{\link{drQuantile}}
}

