% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recombine_transforms.R
\name{drBLB}
\alias{drBLB}
\title{Bag of Little Bootstraps Transformation Method}
\usage{
drBLB(x, statistic, metric, R, n)
}
\arguments{
\item{x}{a subset of a ddf}

\item{statistic}{a function to apply to the subset specifying the statistic to compute.  Must have arguments 'data' and 'weights' - see details).  Must return a vector, where each element is a statistic of interest.}

\item{metric}{a function specifying the metric to be applied to the \code{R} bootstrap samples of each statistic returned by \code{statistic}.  Expects an input vector and should output a vector.}

\item{R}{the number of bootstrap samples}

\item{n}{the total number of observations in the data}
}
\description{
Bag of little bootstraps transformation method
}
\details{
It is necessary to specify \code{weights} as a parameter to the \code{statistic} function because for BLB to work efficiently, it must resample each time with a sample of size \code{n}.  To make this computationally possible for very large \code{n}, we can use \code{weights} (see reference for details).  Therefore, only methods with a weights option can legitimately be used here.
}
\examples{
\dontrun{
# BLB is meant to run on random replicate divisions
rrAdult <- divide(adult, by = rrDiv(1000), update = TRUE)

adultBlb <- rrAdult \%>\% addTransform(function(x) {
  drBLB(x,
    statistic = function(x, weights)
      coef(glm(incomebin ~ educationnum + hoursperweek + sex,
        data = x, weights = weights, family = binomial())),
    metric = function(x)
      quantile(x, c(0.05, 0.95)),
    R = 100,
    n = nrow(rrAdult)
  )
})

# compute the mean of the resulting CI limits
# (this will take a little bit of time because of resampling)
coefs <- recombine(adultBlb, combMean)
matrix(coefs, ncol = 2, byrow = TRUE)
}
}
\author{
Ryan Hafen
}
\references{
Kleiner, Ariel, et al. "A scalable bootstrap for massive data." Journal of the Royal Statistical Society: Series B (Statistical Methodology) 76.4 (2014): 795-816.
}
\seealso{
\code{\link{divide}}, \code{\link{recombine}}
}

