% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extraccion_parrafos.R
\name{extraccion_parrafos}
\alias{extraccion_parrafos}
\title{Extraer parrafos de una columna de texto}
\usage{
extraccion_parrafos(datos, sinonimos = c())
}
\arguments{
\item{datos}{Data frame que contiene los datos de entrada con la columna "contenido".}

\item{sinonimos}{Vector de sinonimos que se incluiran en la busqueda.}
}
\value{
Data frame con una columna adicional 'parrafos_filtrados' que contiene los parrafos extraidos como listas.
}
\description{
Esta funcion procesa una columna de texto en un dataframe y extrae los parrafos que coinciden con los sinonimos proporcionados.
}
\examples{
\donttest{
datos <- extraer_noticias_max_res("inteligencia artificial", max_results = 140, subir_a_bd = FALSE)
datos <- extraccion_parrafos(datos, sinonimos = c("IA", "AI"))
}
}
