/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites.optimizer;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.engine.optimizer.sampling.SamplingFactory;
import com.hp.hpl.jena.sparql.suites.optimizer.Util;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSamplingDynamic
extends TestCase {
    private double factor;
    private int size;
    private static Model testsM;
    private static Model graphM;
    private static final String testDataFileName = "testing/Optimizer/Test-data.n3";
    private static final String testCaseFileName = "testing/Optimizer/TestSampling-manifest.n3";

    public TestSamplingDynamic(String title, String method, double factor, int size) {
        super(title);
        this.factor = factor;
        this.size = size;
    }

    public void runTest() {
        Graph graph = SamplingFactory.defaultSamplingMethod(graphM, this.factor);
        TestSamplingDynamic.assertEquals((int)graph.size(), (int)this.size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Test suite() {
        TestSuite ts = new TestSuite("TestSamplingDynamic");
        testsM = Util.readModel(testCaseFileName);
        graphM = Util.readModel(testDataFileName);
        QueryExecution qe = QueryExecutionFactory.create(TestSamplingDynamic.queryTestCases(), testsM);
        try {
            ResultSet rs = qe.execSelect();
            while (rs.hasNext()) {
                QuerySolution solution = rs.nextSolution();
                String title = solution.getLiteral("title").getLexicalForm();
                String method = solution.getLiteral("method").getString();
                double factor = solution.getLiteral("factor").getDouble();
                int size = solution.getLiteral("size").getInt();
                ts.addTest((Test)new TestSamplingDynamic(title, method, factor, size));
            }
        }
        finally {
            qe.close();
        }
        return ts;
    }

    private static String queryTestCases() {
        return "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>PREFIX dc: <http://purl.org/dc/elements/1.1/>PREFIX : <http://www.w3.org/2006/03/test-description#>SELECT ?title ?method ?factor ?size WHERE {?tc rdf:type :TestCase .?tc dc:title ?title .?tc :method ?method .?tc :factor ?factor .?tc :size ?size .}ORDER BY ASC(?title)";
    }
}

