% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_assign_levlabs.R
\name{util_assign_levlabs}
\alias{util_assign_levlabs}
\title{utility function to assign labels to levels}
\usage{
util_assign_levlabs(
  variable,
  string_of_levlabs,
  splitchar,
  assignchar,
  ordered = TRUE,
  variable_name = "",
  warn_if_inadmissible = TRUE
)
}
\arguments{
\item{variable}{\link{vector} vector with values of a study variable}

\item{string_of_levlabs}{\link{character} len=1. value labels,
e.g. \code{1 = no | 2 = yes}}

\item{splitchar}{\link{character} len=1. splitting character(s) in
\code{string_of_levlabs}, usually \link{SPLIT_CHAR}}

\item{assignchar}{\link{character} len=1. assignment operator character(s) in
\code{string_of_levlabs}, usually \code{=} or \verb{: }}

\item{ordered}{the function converts \code{variable} to a \link{factor}, by default to
an \link{ordered} \link{factor} assuming LHS of assignments being
meaningful numbers, e.g. \code{1 = low | 2 = medium | 3 = high}.
If no special order is given, set \code{ordered} to \code{FALSE},
e.g. for \code{1 = male | 2 = female} or
\code{1 = low | 2 = high | 3 = medium}.}

\item{variable_name}{\link{character} the name of the variable being converted
for warning messages}

\item{warn_if_inadmissible}{\link{logical} warn on \link{con_inadmissible_categorical}
values}
}
\value{
a \link{data.frame} with labels assigned to categorical variables
(if available)
}
\description{
function to assign labels to levels of a variable
}
