% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_compare_meta_with_study.R
\name{util_compare_meta_with_study}
\alias{util_compare_meta_with_study}
\title{Compares study data data types with the ones expected according to the
metadata}
\usage{
util_compare_meta_with_study(
  sdf,
  mdf,
  label_col,
  check_convertible = FALSE,
  threshold_value = 0
)
}
\arguments{
\item{sdf}{the \link{data.frame} of study data}

\item{mdf}{the \link{data.frame} of associated static metadata}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{check_convertible}{\link{logical} also try, if a conversion to the
declared data type would work.}

\item{threshold_value}{\link{numeric} from=0 to=100. percentage failing
conversions allowed if \code{check_convertible}
is \code{TRUE}.}
}
\value{
if \code{check_convertible} is \code{FALSE},
a binary vector \verb{(0, 1)} if data type applies,
if \code{check_convertible} is \verb{TRUE`` a vector with the states }0, 1, 2`: 0 = Mismatch, not convertible
1 = Match
2 = Mismatch, but convertible
}
\description{
Utility function to compare data type of study data with those defined
in metadata
}
