% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pro_applicability_matrix.R
\name{pro_applicability_matrix}
\alias{pro_applicability_matrix}
\title{Check applicability of DQ functions on study data}
\usage{
pro_applicability_matrix(
  study_data,
  meta_data,
  split_segments = FALSE,
  label_col,
  max_vars_per_plot = 20,
  meta_data_segment,
  meta_data_dataframe,
  flip_mode = "noflip"
)
}
\arguments{
\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{split_segments}{\link{logical} return one matrix per study segment}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{max_vars_per_plot}{\link{integer} from=0. The maximum number of variables
per single plot.}

\item{meta_data_segment}{\link{data.frame} -- optional: Segment level metadata}

\item{meta_data_dataframe}{\link{data.frame} -- optional: Data frame level
metadata}

\item{flip_mode}{\link{enum} default | flip | noflip | auto. Should the plot be
in default orientation, flipped, not flipped or
auto-flipped. Not all options are always supported.
In general, this con be controlled by
setting the \code{roptions(dataquieR.flip_mode = ...)}. If
called from \code{dq_report}, you can also pass
\code{flip_mode} to all function calls or set them
specifically using \code{specific_args}.}
}
\value{
a list with:
\itemize{
\item \code{SummaryTable}: data frame about the applicability of each indicator
function (each function in a column).
its \link{integer} values can be one of the following four
categories:
0. Non-matching datatype + Incomplete metadata,
1. Non-matching datatype + complete metadata,
2. Matching datatype + Incomplete metadata,
3. Matching datatype + complete metadata,
4. Not applicable according to data type
\item \code{ApplicabilityPlot}: \link{ggplot2} heatmap plot, graphical representation of
\code{SummaryTable}
\item \code{ApplicabilityPlotList}: \link{list} of plots per (maybe artificial) segment
\item \code{ReportSummaryTable}: data frame underlying \code{ApplicabilityPlot}
}
}
\description{
Checks applicability of DQ functions based on study data and metadata
characteristics
}
\details{
This is a preparatory support function that compares study data with
associated metadata. A prerequisite of this function is that the no. of
columns in the study data complies with the no. of rows in the metadata.

For each existing R-implementation, the function searches for necessary
static metadata and returns a heatmap like matrix indicating the
applicability of each data quality implementation.

In addition, the data type defined in the metadata is compared with the
observed data type in the study data.
}
\examples{
\dontrun{
load(system.file("extdata/meta_data.RData", package = "dataquieR"), envir =
  environment())
load(system.file("extdata/study_data.RData", package = "dataquieR"), envir =
  environment())
appmatrix <- pro_applicability_matrix(study_data = study_data,
                                      meta_data = meta_data,
                                      label_col = LABEL)
}
}
