% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrimeFiles.R
\name{GetPrimeFile}
\alias{GetPrimeFile}
\title{Retrieve a specific Prime file from a DataRobot project}
\usage{
GetPrimeFile(project, primeFileId)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{primeFileId}{numeric. Unique alphanumeric identifier for the primeFile
to be retrieved.}
}
\value{
List with following elements:
\describe{
  \item{language}{Character string. Code programming language}
  \item{isValid}{logical flag indicating if code passed validation}
  \item{rulesetId}{Integer identifier for the ruleset}
  \item{parentModelId}{Unique alphanumeric identifier for the parent model}
  \item{projectId}{Unique alphanumeric identifier for the project}
  \item{id}{Unique alphanumeric identifier for the Prime file}
  \item{modelId}{Unique alphanumeric identifier for the model}
}
}
\description{
This function returns information about specified Prime file from a specified project.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  primeFiles <- ListPrimeFiles(projectId)
  primeFile <- primeFiles[[1]]
  primeFileId <- primeFile$id
  GetPrimeFile(projectId, primeFileId)
}
}
