% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionExplanations.R
\name{GetPredictionExplanationsInitializationFromJobId}
\alias{GetPredictionExplanationsInitializationFromJobId}
\title{Retrieve the prediction explanations initialization for a model using jobId}
\usage{
GetPredictionExplanationsInitializationFromJobId(project, jobId, maxWait = 600)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{jobId}{integer. Unique integer identifier pointing to the prediction explanations job
(returned for example by \code{RequestPredictionExplanationsInitialization}.)}

\item{maxWait}{integer. The maximum time (in seconds) to wait for the model job to complete}
}
\value{
A named list which contains:
\itemize{
  \item projectId character. ID of the project the feature belongs to.
  \item modelId character. The unique alphanumeric model identifier.
  \item predictionExplanationsSample list. List with sample of prediction explanations.
    Each element of the list is information about prediction explanations for one data row.
    For more information see \code{GetPredictionExplanationsRows}.
  }
}
\description{
Prediction explanations initializations are a prerequisite for computing prediction
explanations, and include a sample what the computed prediction explanations for a
prediction dataset would look like.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  model <- GetModel(projectId, modelId)
  jobId <- RequestPredictionExplanationsInitialization(model)
  GetPredictionExplanationsInitializationFromJobId(projectId, jobId)
}
}
