% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Datasaurus-package.r
\docType{data}
\name{twelve_from_slant_alternate_long}
\alias{twelve_from_slant_alternate_long}
\title{Twelve From Slant Alternate (long) data}
\format{A data frame with 2184 rows and 3 variables:
\itemize{
\item \strong{dataset}: the dataset the data are from
\item \strong{x}: x-values
\item \strong{y}: y-values
}}
\usage{
twelve_from_slant_alternate_long
}
\description{
A dataset demonstrating the utility of visualization. These 12 datasets are equal in non-parametric measures: median,
interquartile range, and Spearman's rank correlation.
}
\examples{
if(require(ggplot2)){
  ggplot(twelve_from_slant_alternate_long, aes(x=x, y=y, colour=dataset))+
    geom_point()+
    theme_void()+
    theme(legend.position = "none")+
    facet_wrap(~dataset, ncol=3)
}
}
\references{
Matejka, J., & Fitzmaurice, G. (2017).
Same Stats, Different Graphs: Generating Datasets with
Varied Appearance and Identical Statistics through Simulated
Annealing. \emph{CHI 2017 Conference proceedings: ACM SIGCHI
Conference on Human Factors in Computing Systems.}
Retrieved from \url{https://www.autodeskresearch.com/publications/samestats}.
}
\keyword{datasets}
